@extends('layout')
@section('force-css','bc blog')
@section('style')

@endsection
@section('content')
    @include('partials.breadcrumb')




    <!-- login begin-->
    <div class="contact login">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    @if (session('logout'))
                        <div class="alert alert-danger alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ __(session('logout')) }}
                        </div>
                    @endif
                    @if (session('success'))
                        <div class="alert alert-success alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ __(session('success')) }}
                        </div>
                    @endif
                    @if (session('danger'))
                        <div class="alert alert-danger alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            {{ __(session('danger')) }}
                        </div>
                    @endif


                        @if(Auth::user()->status == 0)
                            <h3 class="text-danger text-center">@lang('Your Account Has been Blocked By Admin')</h3>

                        @else

                            @if(Auth::user()->email_verify == 0)
                                    <form action="{{route('user.send-emailVcode') }}" method="post" class="contact-form">
                                        @csrf
                                        @include('errors.alert')
                                        <div class="row ">
                                            <div class="col-xl-12 col-lg-12">
                                                <div class="form-group text-center">
                                                    <h1 class="margin-bottom-20">@lang('Email Verification')</h1>
                                                    <p>@lang('Your E-mail') : <strong> {{Auth::user()->email}}</strong></p>
                                                    <input type="hidden" name="id" value="{{Auth::user()->id}}">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-12 col-lg-12">
                                            <div class="row d-flex justify-content-center">
                                                <div class="col-xl-3 col-lg-3">
                                                    <button type="submit" class="login-button ">@lang('Resend Code')</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                <form action="{{ route('user.email-verify')}}" method="post" class="contact-form">
                                    @csrf

                                    <input type="hidden" name="id" value="{{Auth::user()->id}}">

                                    <div class="row">
                                        <div class="col-xl-12 col-lg-12">
                                            <div class="form-group">
                                                <label for="InputName">@lang('Enter Code')<span class="requred">*</span></label>
                                                <input type="text" name="email_code" id="InputName" placeholder="@lang('Enter Code')" value="{{old('email_code')}}"  class="form-control" required>
                                                @if ($errors->has('email_code'))
                                                    <span class="error">{{ $errors->first('email_code') }}</span>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="col-xl-12 col-lg-12">
                                            <div class="row d-flex justify-content-center">
                                                <div class="col-xl-3 col-lg-3">
                                                    <button type="submit" class="login-button ">@lang('Submit')</button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </form>


                            @elseif(Auth::user()->phone_verify == 0)

                                <form action="{{route('user.send-vcode') }}" method="post"  class="contact-form">
                                    @csrf
                                    @include('errors.alert')

                                    <div class="row ">
                                        <div class="col-xl-12 col-lg-12">
                                            <div class="form-group text-center">
                                                <h1 class="margin-bottom-20">@lang('SMS Verification')</h1>
                                                <p>@lang('Your Mobile Number') : <strong> {{Auth::user()->phone}}</strong></p>
                                                <input type="hidden" name="id" value="{{Auth::user()->id}}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 col-lg-12">
                                        <div class="row d-flex justify-content-center">
                                            <div class="col-xl-3 col-lg-3">
                                                <button type="submit" class="login-button ">@lang('Resend Code')</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>


                                <form action="{{ route('user.sms-verify')}}" method="post" class="contact-form">
                                    @csrf
                                    <input type="hidden" name="id" value="{{Auth::user()->id}}">
                                    <div class="row">
                                        <div class="col-xl-12 col-lg-12">
                                            <div class="form-group">
                                                <label for="InputName">@lang('Enter Code')<span class="requred">*</span></label>
                                                <input type="text" name="sms_code" id="InputName" placeholder="@lang('Enter Code')" value="{{old('sms_code')}}"  class="form-control" required>
                                                @if ($errors->has('sms_code'))
                                                    <span class="error">{{ $errors->first('sms_code') }}</span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-xl-12 col-lg-12">
                                            <div class="row d-flex justify-content-center">
                                                <div class="col-xl-3 col-lg-3">
                                                    <button type="submit" class="login-button ">@lang('Submit')</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            @else

                                <script>
                                    window.location.href = "{{route('home')}}";
                                </script>
                            @endif



                            @endif
                </div>
            </div>
        </div>
    </div>
    <!-- login end -->

@endsection
